﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;


namespace AZVIC.Ei8htPOS.DAL
{
    public class OCBCHelperDB
    {
        public static AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse GetItem(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentOCBCID", ((OCBCTransactionResponseID != Guid.Empty && OCBCTransactionResponseID != null) ? OCBCTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse>("spGetOrdersPaymentOCBC", parameters);
        }

        public static List<AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse> GetList(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentOCBCID", ((OCBCTransactionResponseID != Guid.Empty && OCBCTransactionResponseID != null) ? OCBCTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse>("spGetOrdersPaymentOCBC", parameters);
        }

        public static DataTable GetDataTable(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentOCBCID", ((OCBCTransactionResponseID != Guid.Empty && OCBCTransactionResponseID != null) ? OCBCTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetOrdersPaymentOCBC", parameters);
        }

        public static DataSet GetDataSet(Guid OCBCTransactionResponseID, Guid ordersPaymentID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersPaymentOCBCID", ((OCBCTransactionResponseID != Guid.Empty && OCBCTransactionResponseID != null) ? OCBCTransactionResponseID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersPaymentID", ((ordersPaymentID != Guid.Empty && ordersPaymentID != null) ? ordersPaymentID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetOrdersPaymentOCBC", parameters);
        }

        public static void Save(AZVIC.Ei8htPOS.Entities.OCBCHelper.OCBCTransactionResponse myTransaction)
        {
            myTransaction.Mode = ((myTransaction.UniqueID != Guid.Empty && myTransaction.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myTransaction.UniqueID = ((myTransaction.UniqueID != Guid.Empty && myTransaction.UniqueID != null) ? myTransaction.UniqueID : Guid.NewGuid());
            if (myTransaction.Mode == GlobalConfigurations.Mode.Insert)
            {
                myTransaction.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@OrdersPaymentOCBCID", myTransaction.UniqueID));
            parameters.Add(new SqlParameter("@OrdersPaymentID", myTransaction.OrdersPaymentID));
            parameters.Add(new SqlParameter("@DeviceRequest", (string.IsNullOrEmpty(myTransaction.DeviceRequest) ? (object)DBNull.Value : myTransaction.DeviceRequest)));
            parameters.Add(new SqlParameter("@DeviceResponse", (string.IsNullOrEmpty(myTransaction.DeviceResponse) ? (object)DBNull.Value : myTransaction.DeviceResponse)));
            parameters.Add(new SqlParameter("@SenderIndicator", (string.IsNullOrEmpty(myTransaction.SenderIndicator) ? (object)DBNull.Value : myTransaction.SenderIndicator)));
            parameters.Add(new SqlParameter("@TransactionType", (string.IsNullOrEmpty(myTransaction.TransactionType.ToString()) ? (object)DBNull.Value : myTransaction.TransactionType.ToString())));
            parameters.Add(new SqlParameter("@MessageVersion", (string.IsNullOrEmpty(myTransaction.MessageVersion) ? (object)DBNull.Value : myTransaction.MessageVersion)));
            parameters.Add(new SqlParameter("@ECRReferenceNo", (string.IsNullOrEmpty(myTransaction.ECRReferenceNo) ? (object)DBNull.Value : myTransaction.ECRReferenceNo)));
            parameters.Add(new SqlParameter("@Amount", (myTransaction.Amount == 0 ? (object)DBNull.Value : myTransaction.Amount)));
            parameters.Add(new SqlParameter("@ResponseCode", (string.IsNullOrEmpty(myTransaction.ResponseCode) ? (object)DBNull.Value : myTransaction.ResponseCode)));
            parameters.Add(new SqlParameter("@MerchantID", (string.IsNullOrEmpty(myTransaction.MerchantID) ? (object)DBNull.Value : myTransaction.MerchantID)));
            parameters.Add(new SqlParameter("@TerminalID", (string.IsNullOrEmpty(myTransaction.TerminalID) ? (object)DBNull.Value : myTransaction.TerminalID)));
            parameters.Add(new SqlParameter("@PrimaryAccountNumber", (string.IsNullOrEmpty(myTransaction.PrimaryAccountNumber) ? (object)DBNull.Value : myTransaction.PrimaryAccountNumber)));
            parameters.Add(new SqlParameter("@CardExpiryDate", (string.IsNullOrEmpty(myTransaction.CardExpiryDate) ? (object)DBNull.Value : myTransaction.CardExpiryDate)));
            parameters.Add(new SqlParameter("@ApprovalCode", (string.IsNullOrEmpty(myTransaction.ApprovalCode) ? (object)DBNull.Value : myTransaction.ApprovalCode)));
            parameters.Add(new SqlParameter("@CardLabel", (string.IsNullOrEmpty(myTransaction.CardLabel) ? (object)DBNull.Value : myTransaction.CardLabel)));
            parameters.Add(new SqlParameter("@RRN", (string.IsNullOrEmpty(myTransaction.RRN) ? (object)DBNull.Value : myTransaction.RRN)));
            parameters.Add(new SqlParameter("@TransactionDateTime", (myTransaction.TransactionDateTime == DateTime.MinValue ? (object)DBNull.Value : myTransaction.TransactionDateTime)));
            parameters.Add(new SqlParameter("@BatchNo", (string.IsNullOrEmpty(myTransaction.BatchNo) ? (object)DBNull.Value : myTransaction.BatchNo)));
            parameters.Add(new SqlParameter("@CardType", (string.IsNullOrEmpty(myTransaction.CardType) ? (object)DBNull.Value : myTransaction.CardType)));
            parameters.Add(new SqlParameter("@PersonsName", (string.IsNullOrEmpty(myTransaction.PersonsName) ? (object)DBNull.Value : myTransaction.PersonsName)));
            parameters.Add(new SqlParameter("@TerminalRefNo", (string.IsNullOrEmpty(myTransaction.TerminalRefNo) ? (object)DBNull.Value : myTransaction.TerminalRefNo)));
            parameters.Add(new SqlParameter("@RedemptionAmount", (myTransaction.RedemptionAmount == 0 ? (object)DBNull.Value : myTransaction.RedemptionAmount)));
            parameters.Add(new SqlParameter("@NetAmount", (myTransaction.NetAmount == 0 ? (object)DBNull.Value : myTransaction.NetAmount)));
            parameters.Add(new SqlParameter("@SequenceNo", (string.IsNullOrEmpty(myTransaction.SequenceNo) ? (object)DBNull.Value : myTransaction.SequenceNo)));
            parameters.Add(new SqlParameter("@ResponseType", (string.IsNullOrEmpty(myTransaction.ResponseType.ToString()) ? (object)DBNull.Value : myTransaction.ResponseType.ToString())));
            parameters.Add(new SqlParameter("@IsValidLRC", myTransaction.IsValidLRC));
            parameters.Add(new SqlParameter("@CreatedBy", ((myTransaction.AdminUserAccountID != Guid.Empty && myTransaction.AdminUserAccountID != null) ? myTransaction.AdminUserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myTransaction.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myOrders.IsDeleted));

            SQLHelper.ExecuteQuery("spAddOrUpdateOrdersPaymentOCBC", parameters);
        }
    }
}
